package gov.va.med.mhv.bluebutton.web.util;

import javax.faces.context.FacesContext;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import com.liferay.portal.model.User;
import com.liferay.portal.util.PortalUtil;

public class UserProfileUtil {
	private static Logger logger = LogManager.getLogger(UserProfileUtil.class);

	public static String getUserFirstName() {
		PortletRequest request = (PortletRequest) FacesContext.getCurrentInstance().getExternalContext().getRequest();
		User user = null;
		String firstName = "";
		try {
			user = PortalUtil.getUser(request);
			if (user != null) {
				firstName = user.getFirstName();
			}
		} catch (Exception e) {
			logger.warn(e);
		}
		return firstName;
	}
	
	public static String getUserLastName() {
		PortletRequest request = (PortletRequest) FacesContext.getCurrentInstance().getExternalContext().getRequest();
		User user = null;
		String lastName = "";
		try {
			user = PortalUtil.getUser(request);
			if (user != null) {
				lastName = user.getLastName();
			}
		} catch (Exception e) {
			logger.warn(e);
		}
		return lastName;
	}
	
	
	public static String getUserFullName() {
		String fullName = "";
		String first = getUserFirstName();
		String last = getUserLastName();
		
		fullName = first != null ? first : "";

		if (last != null) {
			fullName += " " + last;
		}

		return fullName;
	}

	public static Long getUserProfileId() {
		Long userprofileId = null;
		PortletRequest request = (PortletRequest) FacesContext.getCurrentInstance().getExternalContext().getRequest();
		PortletSession session = request.getPortletSession();
		Object profileId = session.getAttribute("LIFERAY_SHARED_userprofileid", PortletSession.APPLICATION_SCOPE);
		if (profileId != null) {
			userprofileId = (Long) profileId;
		}
		return userprofileId;
	}
}
